<?php
declare(strict_types=1);
require __DIR__ . '/config.php';
session_start();
require __DIR__ . '/includes/auth.php';
require_login();

$userId = current_user_id();
$msgId = (int)($_GET['id'] ?? 0);
if ($msgId <= 0) { http_response_code(404); echo "Not found"; exit; }

$stmt = $pdo->prepare("
  SELECT m.*, u.username AS sender_name
  FROM messages m
  JOIN users u ON u.id = m.sender_id
  WHERE m.id = ? AND m.receiver_id = ?
  LIMIT 1
");
$stmt->execute([$msgId, $userId]);
$m = $stmt->fetch();
if (!$m) { http_response_code(404); echo "Not found"; exit; }

// mark read
$pdo->prepare("UPDATE messages SET is_read = 1 WHERE id = ?")->execute([$msgId]);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Message — State of Crime</title>
  <link rel="stylesheet" href="assets/css/app.css" />
</head>
<body>
  <?php include __DIR__ . '/includes/header.php'; ?>
  <div class="shell">
    <?php include __DIR__ . '/includes/sidebar.php'; ?>
    <main class="content">
      <section class="card">
        <h1 class="h1"><?= e($m['subject']) ?></h1>
        <p class="muted">From <?= e($m['sender_name']) ?> • <?= e(date('d M Y H:i', strtotime($m['created_at']))) ?></p>
      </section>

      <section class="card" style="margin-top:14px;">
        <div style="white-space:pre-wrap;line-height:1.6;"><?= e($m['body']) ?></div>
        <div style="display:flex;gap:10px;margin-top:14px;">
          <a class="btn btn--ghost" href="inbox.php">Back</a>
          <a class="btn" href="compose.php?to=<?= urlencode((string)$m['sender_name']) ?>">Reply</a>
        </div>
      </section>
    </main>
    <?php include __DIR__ . '/includes/status_panel.php'; ?>
  </div>
  <script src="assets/js/app.js"></script>
</body>
</html>
