<?php
declare(strict_types=1);
require __DIR__ . '/config.php';
session_start();
require __DIR__ . '/includes/auth.php';
require_login();

$userId = current_user_id();

$windowSeconds = 300;

$stmt = $pdo->prepare("
  SELECT u.id, u.username, u.last_active,
         COALESCE(r.name, 'Unknown') AS rank_name,
         s.points
  FROM users u
  JOIN user_stats s ON s.user_id = u.id
  LEFT JOIN ranks r ON r.id = s.rank_id
  WHERE u.last_active IS NOT NULL AND u.last_active >= (NOW() - INTERVAL ? SECOND)
  ORDER BY u.last_active DESC
");
$stmt->execute([$windowSeconds]);
$players = $stmt->fetchAll();

function fmt_ago(?string $ts): string {
  if (!$ts) return '-';
  $t = strtotime($ts);
  $d = time() - $t;
  if ($d < 0) $d = 0;
  if ($d < 60) return $d . "s ago";
  if ($d < 3600) return intdiv($d, 60) . "m ago";
  return intdiv($d, 3600) . "h ago";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Players Online — State of Crime</title>
  <link rel="stylesheet" href="assets/css/app.css" />
</head>
<body>
  <?php include __DIR__ . '/includes/header.php'; ?>

  <div class="shell">
    <?php include __DIR__ . '/includes/sidebar.php'; ?>

    <main class="content">
      <section class="card">
        <h1 class="h1">Players Online</h1>
        <p class="muted">Shows players active in the last 5 minutes.</p>
      </section>

      <section class="card" style="margin-top:14px;">
        <?php if (!$players): ?>
          <div class="muted">No players online right now.</div>
        <?php else: ?>
          <div style="overflow:auto;">
            <table class="table">
              <thead>
                <tr>
                  <th>Player</th>
                  <th>Rank</th>
                  <th>Points</th>
                  <th>Last Active</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($players as $p): ?>
                  <tr>
                    <td><a class="link" href="profile.php?u=<?= (int)$p['id'] ?>"><?= e($p['username']) ?></a></td>
                    <td><?= e($p['rank_name']) ?></td>
                    <td><?= (int)$p['points'] ?></td>
                    <td><?= e(fmt_ago($p['last_active'])) ?></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </section>
    </main>

    <?php include __DIR__ . '/includes/status_panel.php'; ?>
  </div>

  <script src="assets/js/app.js"></script>
</body>
</html>
