<?php
declare(strict_types=1);
require __DIR__ . '/config.php';
session_start();

if (!empty($_SESSION['user_id'])) {
  header('Location: dashboard.php');
  exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $username = trim((string)($_POST['username'] ?? ''));
  $password = (string)($_POST['password'] ?? '');

  $stmt = $pdo->prepare("SELECT id, password_hash FROM users WHERE username = ? LIMIT 1");
  $stmt->execute([$username]);
  $user = $stmt->fetch();

  if ($user && password_verify($password, $user['password_hash'])) {
    $_SESSION['user_id'] = (int)$user['id'];

    // Mark user active
    $stmt2 = $pdo->prepare("UPDATE users SET last_active = NOW() WHERE id = ?");
    $stmt2->execute([(int)$user['id']]);
    header('Location: dashboard.php');
    exit;
  }

  $error = 'Invalid username or password.';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Login — State of Crime</title>
  <link rel="stylesheet" href="assets/css/app.css" />
</head>
<body class="auth">
  <div class="authcard">
    <div class="authbrand">STATE OF CRIME</div>
    <div class="muted">Login to your account</div>

    <?php if ($error): ?>
      <div class="alert"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post" class="authform">
      <label class="field">
        <span>Username</span>
        <input name="username" required />
      </label>
      <label class="field">
        <span>Password</span>
        <input type="password" name="password" required />
      </label>
      <button class="btn" type="submit">Login</button>
    </form>

    <div class="authlinks">
      <a href="register.php">Register</a>
      <a href="forgot_password.php">Lost password</a>
    </div>
  </div>
</body>
</html>
