<?php
declare(strict_types=1);
require __DIR__ . '/config.php';
session_start();
require __DIR__ . '/includes/auth.php';
require_login();

$userId = current_user_id();

// Fetch basic user (for greeting). Keep minimal.
$stmt = $pdo->prepare("SELECT username FROM users WHERE id = ?");
$stmt->execute([$userId]);
$me = $stmt->fetch() ?: ['username' => 'Player'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>State of Crime</title>
  <link rel="stylesheet" href="assets/css/app.css" />
</head>
<body>
  <?php include __DIR__ . '/includes/header.php'; ?>

  <div class="shell">
    <?php include __DIR__ . '/includes/sidebar.php'; ?>

    <main class="content">

      <section class="card">
        <h1 class="h1">Leaderboard</h1>
        <p class="muted">Top players by rank, money, etc.</p>
      </section>
    
    </main>

    <?php include __DIR__ . '/includes/status_panel.php'; ?>
  </div>

  <script src="assets/js/app.js"></script>
</body>
</html>
