<?php
// includes/auth.php
declare(strict_types=1);

function require_login(): void {
  if (empty($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
  }
}

function current_user_id(): ?int {
  return isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : null;
}

function e(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
}


function csrf_token(): string {
  if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
  }
  return (string)$_SESSION['csrf_token'];
}

function csrf_verify(): void {
  $token = (string)($_POST['csrf_token'] ?? '');
  if (empty($_SESSION['csrf_token']) || !hash_equals((string)$_SESSION['csrf_token'], $token)) {
    http_response_code(400);
    echo "Bad request.";
    exit;
  }
}
