<?php
declare(strict_types=1);
require __DIR__ . '/config.php';
session_start();
require __DIR__ . '/includes/auth.php';
require_login();

$userId = current_user_id();

// Mark selected message as read happens in read_message.php

$stmt = $pdo->prepare("
  SELECT m.id, m.subject, m.is_read, m.created_at, u.username AS sender_name
  FROM messages m
  JOIN users u ON u.id = m.sender_id
  WHERE m.receiver_id = ?
  ORDER BY m.id DESC
  LIMIT 100
");
$stmt->execute([$userId]);
$rows = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Inbox — State of Crime</title>
  <link rel="stylesheet" href="assets/css/app.css" />
</head>
<body>
  <?php include __DIR__ . '/includes/header.php'; ?>
  <div class="shell">
    <?php include __DIR__ . '/includes/sidebar.php'; ?>
    <main class="content">
      <section class="card">
        <div style="display:flex;align-items:center;justify-content:space-between;gap:12px;">
          <div>
            <h1 class="h1">Inbox</h1>
            <p class="muted">Messages sent to you.</p>
          </div>
          <a class="btn" href="compose.php">Compose</a>
        </div>
      </section>

      <section class="card" style="margin-top:14px;">
        <?php if (!$rows): ?>
          <div class="muted">No messages yet.</div>
        <?php else: ?>
          <div style="overflow:auto;">
            <table class="table">
              <thead>
                <tr>
                  <th>From</th>
                  <th>Subject</th>
                  <th>Received</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($rows as $m): ?>
                  <tr style="<?= ((int)$m['is_read'] === 0) ? 'font-weight:800;' : '' ?>">
                    <td><?= e($m['sender_name']) ?></td>
                    <td><a class="link" href="read_message.php?id=<?= (int)$m['id'] ?>"><?= e($m['subject']) ?></a></td>
                    <td class="muted"><?= e(date('d M H:i', strtotime($m['created_at']))) ?></td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </section>
    </main>
    <?php include __DIR__ . '/includes/status_panel.php'; ?>
  </div>
  <script src="assets/js/app.js"></script>
</body>
</html>
