<?php
declare(strict_types=1);
require __DIR__ . '/config.php';
session_start();
require __DIR__ . '/includes/auth.php';
require_login();

$userId = current_user_id();

// Fetch basic user (for greeting). Keep minimal.
$stmt = $pdo->prepare("SELECT username FROM users WHERE id = ?");
$stmt->execute([$userId]);
$me = $stmt->fetch() ?: ['username' => 'Player'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>State of Crime</title>
  <link rel="stylesheet" href="assets/css/app.css" />
</head>
<body>
  <?php include __DIR__ . '/includes/header.php'; ?>

  <div class="shell">
    <?php include __DIR__ . '/includes/sidebar.php'; ?>

    <main class="content">

      <section class="card">
        <h1 class="h1">Welcome back, <?= e($me['username']) ?></h1>
        <p class="muted">Your empire awaits. Choose your next move.</p>
      
      <?php
        $stmt = $pdo->prepare("SELECT jail_until, hospital_until FROM user_stats WHERE user_id = ? LIMIT 1");
        $stmt->execute([$userId]);
        $r = $stmt->fetch() ?: ['jail_until'=>null,'hospital_until'=>null];
        $j = $r['jail_until'] ? max(0, strtotime($r['jail_until']) - time()) : 0;
        $h = $r['hospital_until'] ? max(0, strtotime($r['hospital_until']) - time()) : 0;
      ?>
      <?php if ($j > 0): ?>
        <div class="alert" id="dashboardRestrictions" style="margin-top:12px;">
          You are in jail. <a href="jail.php" style="color:#fff;">Go to Jail</a>
        </div>
      <?php elseif ($h > 0): ?>
        <div class="alert" id="dashboardRestrictions" style="margin-top:12px;">
          You are in hospital. <a href="hospital.php" style="color:#fff;">Go to Hospital</a>
        </div>
      <?php endif; ?>

</section>

      <section class="grid">
        <a class="action" href="crimes.php">
          <div class="action__title">Commit a Crime</div>
          <div class="action__desc">Fast cash. Real risk.</div>
        </a>
        <a class="action" href="car_theft.php">
          <div class="action__title">Car Theft</div>
          <div class="action__desc">Higher rewards, higher heat.</div>
        </a>
        <a class="action" href="organised_crime.php">
          <div class="action__title">Organised Crime</div>
          <div class="action__desc">Crew jobs, shared payouts.</div>
        </a>
        <a class="action" href="inbox.php">
          <div class="action__title">Inbox</div>
          <div class="action__desc">Messages & deals.</div>
        </a>
        <a class="action" href="casino.php">
          <div class="action__title">Casino</div>
          <div class="action__desc">Test your luck.</div>
        </a>
        <a class="action" href="leaderboard.php">
          <div class="action__title">Leaderboard</div>
          <div class="action__desc">Who runs the city?</div>
        </a>
      </section>

      <section class="twocol">
        <div class="card">
          <h2 class="h2">Recent Activity</h2>
          <div id="recentActivity" class="list muted">Loading…</div>
        </div>

        <div class="card">
          <h2 class="h2">Announcements</h2>
          <div id="announcements" class="list muted">Loading…</div>
        </div>
      </section>

    </main>

    <?php include __DIR__ . '/includes/status_panel.php'; ?>
  </div>

  <script src="assets/js/app.js"></script>
</body>
</html>
