<?php
// config.php
declare(strict_types=1);

// --- DATABASE ---
$dbHost = 'localhost';
$dbName = 'YOUR_DB_NAME';
$dbUser = 'YOUR_DB_USER';
$dbPass = 'YOUR_DB_PASSWORD';

// Base URL (optional). Example: https://stateofcrime.co.uk
$baseUrl = '';

// Session security
ini_set('session.cookie_httponly', '1');
ini_set('session.use_strict_mode', '1');

$dsn = "mysql:host={$dbHost};dbname={$dbName};charset=utf8mb4";
$options = [
  PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
  $pdo = new PDO($dsn, $dbUser, $dbPass, $options);
} catch (Throwable $e) {
  http_response_code(500);
  echo "Database connection failed.";
  exit;
}
