<?php
declare(strict_types=1);
require __DIR__ . '/config.php';
session_start();
require __DIR__ . '/includes/auth.php';
require_login();

$userId = current_user_id();

$notice = '';
$error = '';

$to = trim((string)($_POST['to'] ?? ($_GET['to'] ?? '')));
$subject = trim((string)($_POST['subject'] ?? ''));
$body = trim((string)($_POST['body'] ?? ''));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();

  if ($to === '' || $subject === '' || $body === '') {
    $error = "Please fill in To, Subject and Message.";
  } elseif (mb_strlen($subject) > 120) {
    $error = "Subject must be 120 characters or less.";
  } else {
    $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ? LIMIT 1");
    $stmt->execute([$to]);
    $target = $stmt->fetch();

    if (!$target) {
      $error = "User not found.";
    } else {
      $targetId = (int)$target['id'];
      if ($targetId === (int)$userId) {
        $error = "You can't message yourself.";
      } else {
        $stmt = $pdo->prepare("
          INSERT INTO messages (sender_id, receiver_id, subject, body)
          VALUES (?, ?, ?, ?)
        ");
        $stmt->execute([(int)$userId, $targetId, $subject, $body]);
        $notice = "Message sent.";
        $to = $subject = $body = '';
      }
    }
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Compose — State of Crime</title>
  <link rel="stylesheet" href="assets/css/app.css" />
</head>
<body>
  <?php include __DIR__ . '/includes/header.php'; ?>
  <div class="shell">
    <?php include __DIR__ . '/includes/sidebar.php'; ?>
    <main class="content">
      <section class="card">
        <h1 class="h1">Compose</h1>
        <p class="muted">Send a message to another player by username.</p>
        <?php if ($notice): ?><div class="ok" style="margin-top:12px;"><?= e($notice) ?></div><?php endif; ?>
        <?php if ($error): ?><div class="alert" style="margin-top:12px;"><?= e($error) ?></div><?php endif; ?>
      </section>

      <section class="card" style="margin-top:14px;">
        <form method="post" class="grid" style="gap:12px;">
          <input type="hidden" name="csrf_token" value="<?= e(csrf_token()) ?>">
          <label class="field">
            <span class="muted">To (username)</span>
            <input name="to" value="<?= e($to) ?>" maxlength="40" />
          </label>
          <label class="field">
            <span class="muted">Subject</span>
            <input name="subject" value="<?= e($subject) ?>" maxlength="120" />
          </label>
          <label class="field">
            <span class="muted">Message</span>
            <textarea name="body" rows="8" style="width:100%;"><?= e($body) ?></textarea>
          </label>
          <div style="display:flex;gap:10px;align-items:center;">
            <button class="btn" type="submit">Send</button>
            <a class="btn btn--ghost" href="inbox.php">Back to Inbox</a>
          </div>
        </form>
      </section>
    </main>
    <?php include __DIR__ . '/includes/status_panel.php'; ?>
  </div>
  <script src="assets/js/app.js"></script>
</body>
</html>
