<?php
// api/player_status.php
declare(strict_types=1);
require __DIR__ . '/../config.php';
session_start();
require __DIR__ . '/../includes/auth.php';
require_login();

$userId = current_user_id();

$stmt = $pdo->prepare("
  SELECT
    u.username,
    s.money,
    s.bullets,
    s.points,
    s.health,
    s.max_health,
    s.jail_until,
    s.hospital_until,
    r.name AS rank_name
  FROM users u
  JOIN user_stats s ON s.user_id = u.id
  LEFT JOIN ranks r ON r.id = s.rank_id
  WHERE u.id = ?
  LIMIT 1
");
$stmt->execute([$userId]);
$row = $stmt->fetch();

if (!$row) {
  http_response_code(404);
  echo json_encode(['ok' => false, 'message' => 'User not found']);
  exit;
}

// unread messages
$stmt = $pdo->prepare("SELECT COUNT(*) AS c FROM messages WHERE recipient_id = ? AND is_read = 0");
$stmt->execute([$userId]);
$unread = (int)($stmt->fetch()['c'] ?? 0);

echo json_encode([
  'ok' => true,
  'data' => [
    'money' => (int)$row['money'],
    'bullets' => (int)$row['bullets'],
    'points' => (int)$row['points'],
    'health' => (int)$row['health'],
    'max_health' => (int)$row['max_health'],
    'jail_until' => $row['jail_until'],
    'jail_seconds_left' => ($row['jail_until'] ? max(0, strtotime($row['jail_until']) - time()) : 0),
    'hospital_until' => $row['hospital_until'],
    'hospital_seconds_left' => ($row['hospital_until'] ? max(0, strtotime($row['hospital_until']) - time()) : 0),
    'rank' => $row['rank_name'] ?? 'Unknown',
    'unread_messages' => $unread,
  ]
]);
