<?php
// api/hospital_action.php
declare(strict_types=1);
require __DIR__ . '/../config.php';
session_start();
require __DIR__ . '/../includes/auth.php';
require_login();

header('Content-Type: application/json; charset=utf-8');

$userId = current_user_id();

function json_out(bool $ok, string $message, array $extra = []): void {
  echo json_encode(array_merge(['ok'=>$ok, 'message'=>$message], $extra));
  exit;
}

csrf_verify();

$stmt = $pdo->prepare("SELECT money, hospital_until FROM user_stats WHERE user_id = ? LIMIT 1");
$stmt->execute([$userId]);
$s = $stmt->fetch();
if (!$s) json_out(false, "Stats not found.");

$left = $s['hospital_until'] ? max(0, strtotime($s['hospital_until']) - time()) : 0;
if ($left <= 0) json_out(false, "You're not in hospital.");

$payCost = max(200, (int)ceil($left * 3));

if ((int)$s['money'] < $payCost) json_out(false, "Not enough money. Need £{$payCost}.", ['need'=>$payCost]);

$pdo->beginTransaction();
try {
  $stmt = $pdo->prepare("UPDATE user_stats SET money = money - ?, hospital_until = NULL WHERE user_id = ?");
  $stmt->execute([$payCost, $userId]);
  $stmt = $pdo->prepare("INSERT INTO activity_log (user_id, message) VALUES (?, ?)");
  $stmt->execute([$userId, "You paid the doctor and left hospital early."]);
  $pdo->commit();
  json_out(true, "Payment successful. You're free.", ['redirect'=>'dashboard.php']);
} catch (Throwable $e) {
  $pdo->rollBack();
  json_out(false, "Payment failed. Try again.");
}
