<?php
// api/dashboard_feed.php
declare(strict_types=1);
require __DIR__ . '/../config.php';
session_start();
require __DIR__ . '/../includes/auth.php';
require_login();

$userId = current_user_id();

// recent activity (last 10)
$stmt = $pdo->prepare("
  SELECT message, created_at
  FROM activity_log
  WHERE user_id = ?
  ORDER BY created_at DESC
  LIMIT 10
");
$stmt->execute([$userId]);
$activity = $stmt->fetchAll();

// announcements (last 5)
$stmt = $pdo->query("
  SELECT title, body, created_at
  FROM announcements
  ORDER BY created_at DESC
  LIMIT 5
");
$ann = $stmt->fetchAll();

echo json_encode([
  'ok' => true,
  'data' => [
    'activity' => $activity,
    'announcements' => $ann,
  ]
]);
